// Preloader

let preloader = document.getElementById('site-loader');
hidePreloader();

function hidePreloader() {
    setTimeout(() => {
        preloader.classList.add('hide-loader');
        setTimeout(() => {
            preloader.style.display = 'none';
        }, 600);
    }, 1000);
}


// COOKIE Variables

function getCookie(name) {
    const value = `; ${document.cookie}`;
    const parts = value.split(`; ${name}=`);
    if (parts.length === 2) return parts.pop().split(';').shift();
}

function fillInVars(var_name) {
    let items = document.querySelectorAll('.'+var_name);
    for (const item of items) {
        let cookieValue = getCookie(var_name);
        if (cookieValue) {
            item.innerHTML = cookieValue.replaceAll('%20', ' ').replaceAll('%40', '@');
        } else {
            item.innerHTML = '';
        }
    }
}

fillInVars('tracking_code');
fillInVars('city');
fillInVars('country');
fillInVars('currency');
fillInVars('day_1');
fillInVars('day_1_name');
fillInVars('day_2');
fillInVars('day_2_name');
fillInVars('email');
fillInVars('shipping');
fillInVars('shipping_price');


let tracking_code = document.querySelector('#tracking_code');
if(tracking_code) {
    tracking_code.value = getCookie('tracking_code');
}


// NAV
let nav_btn = document.querySelector('#nav');
let navigation = document.querySelector('#navigation');

nav_btn.addEventListener('click', (e) => {
    console.log('nav click');
    if(navigation) {
        navigation.classList.toggle('hidden');
    }
});

// OPEN LOGIN
let login_1 = document.querySelector('#login-1');
if(login_1) {
    login_1.addEventListener('click', (e) => {
        document.querySelector('#login-btn').click();
        if(navigation) {
            navigation.classList.add('hidden');
        }
    });
}


//EXPANDABLE DIV
let exp_next = document.querySelectorAll(".expand-next");

for (const clicker of exp_next) {
    const arrow = clicker.querySelector('.arrow');
    clicker.addEventListener('click', (event) => {


            if (arrow.classList.contains('rotate-180')) {
                setTimeout(() => {
                    arrow.classList.remove('rotate-180');
                }, 300);
            } else {
                arrow.classList.add('rotate-180');
            }



        const nextExpandElement = clicker.nextElementSibling;
        if (nextExpandElement.classList.contains('expanded')) {
            nextExpandElement.classList.remove('expanded');
        } else {
            nextExpandElement.classList.add('expanded');
        }
    });
}
