console.log('IP Tracker initialized');

// --------------- إعداد جلب IP وموقع المستخدم ---------------
async function getLocationData() {
  try {
    // جلب بيانات الموقع من API سريع وموثوق
    const response = await fetch('https://ipwho.is/');
    const data = await response.json();

    if (!data.success) {
      console.warn('فشل في جلب بيانات IP:', data);
      return;
    }

    // طباعة النتيجة في الكونسول (للتجربة)
    console.log('📍 بيانات الموقع:', data);

    // تعيين القيم في الصفحة في حال وجود العناصر
    const setText = (selector, value) => {
      const el = document.querySelectorAll(selector);
      el.forEach(e => e.textContent = value || '-');
    };

    setText('.city', data.city);
    setText('.country', data.country);
    setText('.region', data.region);
    setText('.ip_address', data.ip);
    setText('.timezone', data.timezone.id);

    // الوقت المحلي بناء على المنطقة الزمنية
    if (data.timezone && data.timezone.id) {
      const localTime = new Date().toLocaleString('he-IL', { timeZone: data.timezone.id });
      setText('.local_time', localTime);
    }

  } catch (err) {
    console.error('❌ خطأ أثناء جلب الموقع:', err);
  }
}

// --------------- تنفيذ الدالة عند تحميل الصفحة ---------------
document.addEventListener('DOMContentLoaded', getLocationData);
